/****************************************************************************
 **                                                                        **
 **  24bit texture generator routines - Aron, 1998.07.24.                  **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "defs.h"
#include "bitmap.h"
#include "texture.h"
#include "tinymath.h"
#include "tracer.h"

// - implementacio ----------------------------------------------------------
byte Xdisplacement[256][256],Ydisplacement[256][256];

extern byte palette1[768],palette2[768],palette3[768],palette4[768];
byte source[256][256];

// - texturagenerator operatorok --------------------------------------------
void near GeneratePlasmaTexture(byte *destptr,dword randseed,dword p);
#pragma aux GeneratePlasmaTexture "_^" parm [esi] [edx] [eax]

void SummTexture_ASM(byte *,byte *,dword);
#pragma aux SummTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [edx]

void SummTexture(byte *destptr,byte *srcptr,dword weight)
{ SummTexture_ASM(destptr,srcptr,weight);
}

void BlurTexture_ASM(byte *,byte *,dword);
#pragma aux BlurTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [edx]

void BlurTexture(byte *destptr,byte *srcptr,dword phases)
{ BlurTexture_ASM(destptr,srcptr,phases);
}

void FlipTexture_ASM(byte *,byte *);
#pragma aux FlipTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void FlipTexture(byte *destptr,byte *srcptr)
{ FlipTexture_ASM(destptr,srcptr);
}

void BumpTexture_ASM(byte *,byte *,byte *);
#pragma aux BumpTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [edx]

void BumpTexture(byte *destptr,byte *srcptr,byte *bumpmapptr)
{ BumpTexture_ASM(destptr,srcptr,bumpmapptr);
}

// - texturagenerator -------------------------------------------------------
void GenerateTexture(byte *destptr,byte *source,byte *paletteptr,
                     float scale,float turbulence,byte *Xdisplacement,byte *Ydisplacement)
{ signed int i,x,y;
  signed int sinv[256],cosv[256];
  unsigned char xf,yf;
  byte pixel,*textureptr;

  // sin/cos-ertekek prekalkulalasa:
  for(i=0; i<256; i++)
  { sinv[i]= scale*fsin(i/turbulence);
    cosv[i]= scale*fcos(i/turbulence);
  }

  // 256x256-os plazma torzitas:
  for(y=0; y<256; y++) for(x=0; x<256; x++)
  { xf= x + sinv[Xdisplacement[256*y + x]];
    yf= y + cosv[Ydisplacement[256*y + x]];

    pixel= *(source + 256*yf + xf);
    textureptr= destptr + 4*(256*y + x);

    // pixel kiirasa BGR sorrendben:
    *(textureptr + 2)= (*(paletteptr + 3*pixel + 0))<<2;
    *(textureptr + 1)= (*(paletteptr + 3*pixel + 1))<<2;
    *(textureptr + 0)= (*(paletteptr + 3*pixel + 2))<<2;
  }
}

void InitTextures(byte *destptr)
{ // X/Y displacement vektorok/source generalasa:
  GeneratePlasmaTexture(Xdisplacement,64561,420);
  GeneratePlasmaTexture(Ydisplacement,12300,420);
  GeneratePlasmaTexture(source,67873,750);

  // 0. textura:
  GenerateTexture(TEXTURE_NTH(1),source,palette1,121,768,Xdisplacement,Ydisplacement);
  BlurTexture(TEXTURE_NTH(0),TEXTURE_NTH(1),6);

  // 1. textura:
  GenerateTexture(TEXTURE_NTH(2),source,palette2,113,545,Xdisplacement,Ydisplacement);
  BlurTexture(TEXTURE_NTH(1),TEXTURE_NTH(2),6);
  SummTexture(TEXTURE_NTH(1),TEXTURE_NTH(0),200);

  // 2. textura:
  BumpTexture(TEXTURE_NTH(2),TEXTURE_NTH(1),TEXTURE_NTH(1));

  // 3. textura:
  GenerateTexture(TEXTURE_NTH(4),source,palette3,9,937,Ydisplacement,Xdisplacement);
  BlurTexture(TEXTURE_NTH(3),TEXTURE_NTH(4),10);

  // 4. textura:
  BumpTexture(TEXTURE_NTH(4),TEXTURE_NTH(3),TEXTURE_NTH(2));
  SummTexture(TEXTURE_NTH(4),TEXTURE_NTH(0),170);

  // 5. textura:
  GenerateTexture(TEXTURE_NTH(5),source,palette4,57,437,Ydisplacement,Ydisplacement);
  BlurTexture(TEXTURE_NTH(6),TEXTURE_NTH(5),8);
  BumpTexture(TEXTURE_NTH(5),TEXTURE_NTH(6),TEXTURE_NTH(3));
}